//Caption: Scilab code for Edge Detection using Different Edge detectors 
//[1]LoG  [2] DoG
//Software version
//For: OS Windows7 and 8
//Scilab5.4.1 and above
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//For: OS Ubuntu Linux 14.04 and above
//Scilab5.5.1 
//Image Processing Design Toolbox 8.3.1 and above
//Scilab Image and Video Proccessing toolbox 0.5.3.1-2 and above
//To read and write in the correct folder
//change the current directory in scilab console
close;
a = imread('Exp7lena.jpg');
//LAPLACIAN OF GAUSSIAN////////////////////////////////////////////////
[c,thresh] = edge(a,'log',0.2,'both',2);
//d = edge(a,'prewitt');
ShowImage(a,'Original Image')
title('Original Image')
figure
ShowImage(c,'Edge Detected Image-LoG')
///////////////////////////////////////////////////////////////////////
//DERIVATIVE OF GAUSSIAN FUNCTION
function [mask]=DoG(op1,op2)
    //If op1 and op2 are not specified -Default size 3x3
    if isempty(op1) then
       siz = [3,3];
    else
       if length(op1)==1 then
	       siz = [op1, op1];
       elseif length(op1)==2 then
	       siz = op1;
       else
	       error("The second argument should have 1 or 2 elements for gaussian filter");
       end
    end
     //set std for the filter
    if isempty(op2) then
       g_std = 0.5;
    else
       if length(op2)>1 then
	       error("The third argument should have only 1 element for gaussian filter");
       else
	       g_std = op2;
       end
    end
     sizx = (siz(2)-1)/2;
     sizy = (siz(1)-1)/2;
     x2 = ones(siz(1),1) * ([-sizx:sizx]^2);
     y2 = ([-sizy:sizy]^2)' * ones(1, siz(2));
     r = sqrt(x2+y2);
     sigma = g_std;
     F = (1/(sigma^2))*(((r.*r)/sigma^2)-1).*exp(-r.*r/2*sigma^2);
     F(F<%eps*max(F)) = 0;
     sumF=sum(F);
     if sumF~=0 then
       F = F / sum(F);
     end
     mask = F;
endfunction
mask =  DoG([],[]);
mx=filter2(mask,a);
my=filter2(mask',a);
border=sqrt(mx.*mx + my.*my);
if thresh >=0 then
   scale_thresh = min(border) * (1-thresh) + max(border)*thresh;
   border=border > scale_thresh;
end
d = border;
////////////////////////////////////////////////////////////////////////////////
figure
ShowImage(d,'Edge Detected Image-DoG')
